<!------------------------------------------------------------------------------->
<!-----------------------------COPIA AI BRXO------------------------------------->
<!-----------------------DEVELOPER: EMANUEL NASCIMENTO--------------------------->
<!--------------------CONTATO: https://t.me/ebjnasciment------------------------->
<!------------------------------------------------------------------------------->


<?php
session_start();

// Verifica se o usuário está logado
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header('Location: login.php');
    exit;
}

include "./includes/header.php";

// Caminho do banco de dados
$db_path = 'api/db.db';

// Conectar ao banco de dados SQLite
try {
    $pdo = new PDO("sqlite:" . $db_path);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

$mensagem = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $novo_usuario = trim($_POST['novo_usuario']);
    $nova_senha = trim($_POST['nova_senha']);
    
    if (empty($novo_usuario) || empty($nova_senha)) {
        $mensagem = "<p class='mensagem error'>Todos os campos são obrigatórios.</p>";
    } else {
        // Atualizar o usuário no banco de dados
        try {
            $senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE usuarios SET usuario = ?, senha = ? WHERE id = 1");
            $stmt->execute([$novo_usuario, $senha_hash]);
            $_SESSION['usuario'] = $novo_usuario;
            $mensagem = "<p class='mensagem sucesso'>Dados atualizados com sucesso!</p>";
        } catch (PDOException $e) {
            $mensagem = "<p class='mensagem error'>Erro ao atualizar: " . $e->getMessage() . "</p>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #1e1e1e;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .container {
            background-color: rgba(0, 0, 0, 0.7);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 10px 30px rgba(0, 0, 0, 0.5);
            width: 100%;
            max-width: 600px;
            text-align: center;
            border: 1px solid;
        }

        .input-group {
            margin-bottom: 20px;
            text-align: left;
        }

        .input-group label {
            display: block;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .input-group input {
            width: 100%;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #444;
            background-color: #333;
            color: #fff;
            font-size: 16px;
            box-sizing: border-box;
            transition: border-color 0.3s;
        }

        .input-group input:focus {
            border-color: #1abc9c;
            outline: none;
        }

        button {
            background-color: #1abc9c;
            color: #fff;
            border: none;
            padding: 15px 30px;
            font-size: 18px;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button:hover {
            background-color: #16a085;
        }

        .mensagem {
            margin: 10px 0;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }

        .mensagem.sucesso {
            background-color: #2ecc71;
            color: #fff;
        }

        .mensagem.error {
            background-color: #e74c3c;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 style= "color: white";>Atualizar Perfil</h1>
        <?php echo $mensagem; ?>
        <form method="POST">
            <div class="input-group">
                <label for="novo_usuario">Novo Usuário</label>
                <input type="text" id="novo_usuario" name="novo_usuario" required>
            </div>
            <div class="input-group">
                <label for="nova_senha">Nova Senha</label>
                <input type="password" id="nova_senha" name="nova_senha" required>
            </div>
            <button type="submit">Atualizar</button>
        </form>
    </div>
     <?php include './includes/footer.php';?>
</body>
</html>
