<!------------------------------------------------------------------------------->
<!-----------------------------COPIA AI BRXO------------------------------------->
<!-----------------------DEVELOPER: EMANUEL NASCIMENTO--------------------------->
<!--------------------CONTATO: https://t.me/ebjnasciment------------------------->
<!------------------------------------------------------------------------------->


<?php
session_start();

// Verifica se o usuário está logado
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header('Location: login.php');
    exit;
}




// Diretório onde os arquivos JSON estão armazenados
$diretorio_json = 'uploads/';
$arquivos_json = [];

// Verifica se foi solicitado para excluir um app
if (isset($_POST['deletar_app'])) {
    $arquivo_json = $_POST['deletar_app'];

    // Verifica se o arquivo JSON existe
    if (file_exists($diretorio_json . $arquivo_json)) {
        // Ler o conteúdo do arquivo JSON
        $json_data = file_get_contents($diretorio_json . $arquivo_json);
        $app_data = json_decode($json_data, true);

        // Excluir os arquivos de logo, se existirem
        if (isset($app_data['logo']) && is_array($app_data['logo'])) {
            foreach ($app_data['logo'] as $logo) {
                if (file_exists($logo)) {
                    unlink($logo);  // Apaga o logo
                }
            }
        }

        // Excluir o arquivo de aplicativo (.apk), se existir
        if (isset($app_data['arquivo'])) {
            $caminho_apk = $diretorio_json . basename($app_data['arquivo']);
            if (file_exists($caminho_apk)) {
                unlink($caminho_apk);  // Apaga o arquivo .apk
            }
        }

        // Excluir o arquivo JSON
        unlink($diretorio_json . $arquivo_json);
    }

    // Limpar o cache do navegador
    header("Cache-Control: no-cache, no-store, must-revalidate");
    header("Pragma: no-cache");
    header("Expires: 0");

    // Redireciona para listapp.php
    header('Location: listapp.php');
    exit;
}

if ($handle = opendir($diretorio_json)) {
    while (false !== ($entry = readdir($handle))) {
        // Verifica se é um arquivo JSON
        if (pathinfo($entry, PATHINFO_EXTENSION) === 'json') {
            $arquivos_json[] = $entry;
        }
    }
    closedir($handle);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Apps</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet"> <!-- Importando Font Awesome -->
    <style>
        /* Seu estilo aqui */
        body {
            font-family: 'Arial', sans-serif;
            background-color: #1e1e1e;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
            margin: 0;
        }

        .container {
            background-color: rgba(0, 0, 0, 0.8);
            padding: 30px;
            border-radius: 10px;
            width: 100%;
            max-width: 900px;
            box-shadow: 0px 10px 30px rgba(0, 0, 0, 0.5);
            text-align: center;
            border: 1px solid;
            position: relative;
            top: 90px;
        }

        h2 {
            font-size: 24px;
            margin-bottom: 20px;
            color: #fff;
        }

        .table-container {
            overflow-y: auto;
            max-height: 500px;
            margin-top: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: rgba(0, 0, 0, 0.7);
            border-radius: 8px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.5);
        }

        th, td {
            padding: 15px;
            text-align: center;
            font-size: 16px;
            color: #fff;
            border: 1px solid #444;
        }

        th {
            background-color: #333;
        }

        tr:nth-child(even) {
            background-color: #2c2c2c;
        }

        tr:hover {
            background-color: #115754;
        }

        td img {
            width: 75px;
            height: 50px;
            object-fit: cover;
            border-radius: 5px;
        }

        a {
            color: #1abc9c;
            text-decoration: none;
            font-weight: bold;
        }

        a:hover {
            color: #16a085;
        }

        .action-buttons {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 0;
            margin: 0;
            height: 100%;
        }

        .action-buttons button {
            background-color: #fc1800;
            border: 1px solid #e60000;
            color: white;
            padding: 8px 12px;
            font-size: 18px;
            cursor: pointer;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s ease;
        }

        .action-buttons button:hover {
            background-color: #e60000;
        }

        .delete-button i {
            color: white;
            margin-right: 8px;
        }

        .carousel-container {
            width: 100%;
            max-width: 75px;
            margin: 0 auto;
        }

        .carousel-container img {
            width: 75px;
            height: 50px;
            object-fit: cover;
            border-radius: 5px;
            display: none;
        }

        .btn-flutuante {
            position: fixed;
            left: 20px;
            top: 20px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 50%;
            padding: 15px;
            font-size: 20px;
            cursor: pointer;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.3);
            z-index: 10;
            transition: background-color 0.3s ease;
        }

        .btn-flutuante:hover {
            background-color: #2980b9;
        }

        .btn-flutuante i {
            margin-left: 0px;
        }
        
        /* Estilo para o botão de retorno */
.return-button {
    position: absolute;
    top: 20px;
    left: 20px;
    background-color: transparent;
    border: none;
    color: black;  /* Cor do texto em preto */
    font-size: 24px;
    cursor: pointer;
    display: flex;
    align-items: center;
}

.return-button:hover {
    color: #555;  /* Cor de texto quando o botão é hover */
}

.return-button i {
    margin-right: 8px;
}


        
    </style>
</head>
<body>
    <!-- Botão de retorno -->
<div class="return-button">
    <a href="cadastro.php">
        <i class="fas fa-arrow-left" style="color: red";></i style="color: white";> Voltar
    </a>
</div>

    <div class="container">
        <h2>Lista de Apps Cadastrados</h2>
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Nome do App</th>
                        <th>Descrição</th>
                        <th>URL</th>
                        <th>Logo</th>
                        <th>Arquivo</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
// Exibir informações de cada arquivo JSON
foreach ($arquivos_json as $arquivo_json) {
    // Ler o conteúdo do arquivo JSON
    $json_data = file_get_contents($diretorio_json . $arquivo_json);
    $app_data = json_decode($json_data, true);

    if ($app_data) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($app_data['nome']) . "</td>";
        echo "<td>" . htmlspecialchars($app_data['descricao']) . "</td>";
        echo "<td>" . htmlspecialchars($app_data['url']) . "</td>";

        if (isset($app_data['logo']) && is_array($app_data['logo'])) {
            if (count($app_data['logo']) > 1) {
                echo "<td><div class='carousel-container' id='carousel-".md5($arquivo_json)."'>"; 
                foreach ($app_data['logo'] as $index => $logo) {
                    // Substituir caminho local para URL pública dinamicamente
                    // Ajusta o caminho com o DOCUMENT_ROOT para criar a URL pública
                    $logo_path = str_replace($_SERVER['DOCUMENT_ROOT'], 'https://' . $_SERVER['HTTP_HOST'], $logo);
                    echo "<img src='" . htmlspecialchars($logo_path) . "' alt='Logo' class='carousel-image'>";
                }
                echo "</div></td>";
            } else {
                $logo_path = str_replace($_SERVER['DOCUMENT_ROOT'], 'https://' . $_SERVER['HTTP_HOST'], $app_data['logo'][0]); 
                echo "<td><img src='" . htmlspecialchars($logo_path) . "' alt='Logo'></td>";
            }
        } else {
            echo "<td>Sem logo</td>";
        }

        // Exibe o arquivo APK como link para download
        echo "<td><a href='" . htmlspecialchars($diretorio_json . $app_data['arquivo']) . "' download>Baixar App</a></td>";

        // Exibe o botão de exclusão
        echo "<td>
                <div class='action-buttons'>
                    <button class='delete-button' onclick='deletarApp(\"$arquivo_json\")'>
                        <i class='fas fa-trash'></i> Deletar
                    </button>
                </div>
              </td>";
        echo "</tr>";
    }
}
?>

                </tbody>
            </table>
        </div>
         <?php include './includes/footer.php';?>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Inicialização do carrossel
        $(document).ready(function() {
            $(".carousel-container").each(function() {
                var $carousel = $(this);
                var images = $carousel.find('img');
                var currentIndex = 0;

                function showImage(index) {
                    images.hide();
                    images.eq(index).show();
                }

                showImage(currentIndex);

                setInterval(function() {
                    currentIndex = (currentIndex + 1) % images.length;
                    showImage(currentIndex);
                }, 3000); // Troca a cada 3 segundos
            });
        });

        function deletarApp(nomeApp) {
            if (confirm("Tem certeza que deseja deletar este app?")) {
                var form = document.createElement("form");
                form.method = "POST";
                form.action = "";
                var input = document.createElement("input");
                input.type = "hidden";
                input.name = "deletar_app";
                input.value = nomeApp;
                form.appendChild(input);
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</body>
</html>
