<?php
// Iniciar a sessão (se já não estiver iniciada)
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Administrativo</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            flex-direction: column;
            height: 100vh;
            overflow-x: hidden;
        }

        .topbar {
            width: 100%;
            background-color: #2c3e50;
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            height: 50px; /* Altura fixa da topbar */
        }

        .sidebar {
            width: 250px;
            background: url('https://img.freepik.com/fotos-gratis/fundo-desfocado-escuro-abstrato-cor-de-textura-de-gradiente-suave-padrao-de-site-brilhante-brilhante-cabecalho-de-banner-ou-imagem-de-arte-grafica-de-barra-lateral_1258-85524.jpg') center/cover;
            color: white;
            height: calc(100vh - 50px); /* Altura total menos a topbar */
            padding: 20px;
            position: fixed;
            top: 50px; /* Abaixo da topbar */
            left: 0;
            backdrop-filter: blur(8px);
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            transition: left 0.3s ease-in-out;
            z-index: 1002;
        }

        .sidebar ul {
            list-style: none;
            padding-top: 20px;
            text-align: center;
            width: 100%;
            padding: 0;
        }

        .sidebar ul li {
            margin-bottom: 20px;
            width: 100%;
            display: flex;
            justify-content: center;
        }

        .sidebar ul li a {
            color: white;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 10px;
            background: rgba(0, 0, 0, 0.5);
            transition: all 0.3s ease-in-out;
            position: relative;
            margin: 0 auto;
            width: 80%;
            justify-content: center;
            text-align: center;
            box-shadow: 0 0 8px rgba(0, 232, 43, 0.4), 0 0 15px rgba(0, 232, 43, 0.5), 0 0 20px rgba(0, 232, 43, 0.6);
        }

        .sidebar ul li a:hover {
            background: rgba(0, 232, 43, 0.8);
            color: white;
            transform: scale(1.05);
            box-shadow: 0 0 18px rgba(8, 110, 252, 0.7), 0 0 25px rgba(8, 110, 252, 0.8), 0 0 35px rgba(8, 110, 252, 0.9);
            text-shadow: 0 0 8px rgba(8, 110, 252, 0.6), 0 0 12px rgba(8, 110, 252, 0.7), 0 0 18px rgba(8, 110, 252, 0.8);
        }

        .sidebar ul li a i {
            margin-right: 10px;
            text-shadow: 0 0 5px rgba(0, 232, 43, 0.5), 0 0 10px rgba(0, 232, 43, 0.6);
        }

        .main-content {
            margin-left: 250px;
            padding: 20px;
            width: calc(100% - 250px);
            height: calc(100vh - 50px); /* Altura total menos a topbar */
            display: flex;
            justify-content: flex-start;
            text-align: center;
            flex-direction: column;
            overflow-y: auto; /* Permite rolagem no conteúdo principal */
            margin-top: 50px; /* Ajustado para a altura da topbar */
        }

        .content-container {
            background-color: rgba(0, 0, 0, 0.7);
            padding: 30px;
            margin-top: 0px; /* Removido margem superior */
            margin-left: 20px;
            margin-right: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.4), 0 0 20px 5px rgba(255, 255, 255, 0.6);
            width: 90%;
            max-width: 90%;
            box-sizing: border-box;
            text-align: center;
            flex: 1; /* Ocupa o espaço restante */
            overflow-y: auto; /* Permite rolagem interna */
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            align-items: center;
            min-height: 0; /* Garante que o container não ultrapasse os limites */
            border: 2px solid white;
        }

        .footer {
            width: 100%;
            text-align: center;
            padding: 10px;
            color: white;
            border-radius: 0 0 12px 12px;
        }

        .footer a {
            color: #1abc9c;
            text-decoration: none;
            font-weight: bold;
        }

        @media (max-width: 600px) {
            .sidebar {
                left: -250px;
            }

            .sidebar.open {
                left: 0;
            }

            .main-content {
                margin-left: 0;
                width: 100%;
            }

            .content-container {
                width: 100%;
                margin-left: 0;
                margin-right: 0;
                padding: 20px;
                box-sizing: border-box;
            }

            .menu-btn {
                display: block;
            }
        }

        @media (min-width: 601px) {
            .menu-btn {
                display: none;
            }
        }

        .menu-btn {
            position: fixed;
            top: 10px;
            left: 10px;
            font-size: 30px;
            background: #333;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px;
            border-radius: 50%;
            z-index: 1001;
            transition: left 0.3s ease-in-out;
        }
    </style>
</head>
<body>
    <button class="menu-btn" onclick="toggleMenu()">☰</button>
    <div class="topbar">Painel Administrativo</div>
    <div class="sidebar">
        <ul>
            <li><a href="profile.php"><i class="fas fa-user-circle"></i> PROFILE</a></li>
            <li><a href="cadastro.php"><i class="fas fa-cogs"></i> CRIAR APK</a></li>
            <li><a href="index.php" target="_blank"><i class="fas fa-store-alt"></i> LOJA WEB</a></li>
            <li><a href="listapp.php"><i class="fas fa-th-list"></i>APPS UPADOS</a></li>
            <li><a href="logout.php" style="color: red"><i class="fas fa-sign-out-alt"></i>SAIR</a></li>
            <li><a href="https://t.me/ebjnasciment" target="_blank"><i class="fab fa-whatsapp"></i>Entrar em Contato</a></li>
        </ul>
    </div>
   
    <script>
        function toggleMenu() {
            const sidebar = document.querySelector('.sidebar');
            const menuBtn = document.querySelector('.menu-btn');
            sidebar.classList.toggle('open');

            if (sidebar.classList.contains('open')) {
                menuBtn.style.left = '260px';
            } else {  
                menuBtn.style.left = '10px';
            }
        }
    </script>
</body>
</html>