<!------------------------------------------------------------------------------->
<!-----------------------------COPIA AI BRXO------------------------------------->
<!-----------------------DEVELOPER: EMANUEL NASCIMENTO--------------------------->
<!--------------------CONTATO: https://t.me/ebjnasciment------------------------->
<!------------------------------------------------------------------------------->



<?php
session_start();

// Verifica se o usuário está logado
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header('Location: login.php');
    exit;
}

// Incluir o header
include './includes/header.php';

// Processar formulário
$mensagem = "";
$mensagem_sucesso = false;  // Variável para controlar o sucesso do cadastro

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? null;
    $url = $_POST['url'] ?? null;
    $descricao = $_POST['descricao'] ?? null;
    $logos = [];  // Aqui vamos armazenar as logos enviadas
    $arquivo = null;

    // Verifica se o nome foi preenchido
    if (!$nome) {
        $mensagem = "O nome do app é obrigatório.";
    } else {
        // Sanitize o nome para evitar caracteres especiais
        $nome_slug = preg_replace('/[^a-zA-Z0-9-_]/', '_', strtolower($nome));

        // Verificar se já existe um arquivo JSON com o nome do app
        $json_filename = __DIR__ . '/uploads/' . $nome_slug . '.json';  // Caminho absoluto para a pasta de uploads
        if (file_exists($json_filename)) {
            // Se o arquivo JSON já existir, exibe a mensagem de erro
            $mensagem = "Já existe um app cadastrado com esse nome. Tente outro nome.";
        } else {
            // Verificar se a pasta de uploads existe
            $upload_dir = __DIR__ . '/uploads/';
            if (!is_dir($upload_dir)) {
                if (!mkdir($upload_dir, 0777, true)) {
                    $mensagem = "Erro ao criar o diretório de uploads.";
                }
            }

            // Upload de múltiplas logos se enviadas
            if (!empty($_FILES['logo']['name'][0])) {
                // Iterar sobre os arquivos de logo enviados
                foreach ($_FILES['logo']['name'] as $key => $logo_name) {
                    // Verificar erros no upload
                    if ($_FILES['logo']['error'][$key] !== UPLOAD_ERR_OK) {
                        $mensagem = "Erro no upload da logo: " . $_FILES['logo']['error'][$key];
                        break;
                    }

                    // Renomear cada logo com o nome do app e índice
                    $extensao = pathinfo($logo_name, PATHINFO_EXTENSION);
                    $nome_arquivo_logo = $nome_slug . ($key + 1) . "." . $extensao;  // Usando nome do app + índice
                    $caminho_completo_logo = $upload_dir . $nome_arquivo_logo;

                    // Mover o arquivo para o diretório de upload
                    if (move_uploaded_file($_FILES['logo']['tmp_name'][$key], $caminho_completo_logo)) {
                        $logos[] = $caminho_completo_logo;  // Adicionar a logo no array
                    } else {
                        $mensagem = "Erro ao enviar a imagem da logo.";
                        break;
                    }
                }
            }

           // Upload do arquivo do app
if (!empty($_FILES['arquivo']['name'])) {
    // Verificar erros no upload
    if ($_FILES['arquivo']['error'] !== UPLOAD_ERR_OK) {
        $mensagem = "Erro no upload do arquivo: " . $_FILES['arquivo']['error'];
    } else {
        $extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
        $nome_arquivo_app = $nome_slug . "." . $extensao;  // Usando nome do app + extensão
        $caminho_completo_arquivo = $upload_dir . $nome_arquivo_app;

        if (move_uploaded_file($_FILES['arquivo']['tmp_name'], $caminho_completo_arquivo)) {
            $arquivo = 'uploads/' . $nome_arquivo_app; // Caminho relativo
        } else {
            $mensagem = "Erro ao enviar o arquivo do app.";
        }
    }
}

            // Criar array com as informações do app
            $appData = [
                'nome' => $nome,
                'url' => $url,
                'descricao' => $descricao,
                'logo' => $logos,  // Salvar todas as logos em um array
                'arquivo' => $arquivo
            ];

            // Salvar o arquivo JSON
            if (file_put_contents($json_filename, json_encode($appData, JSON_PRETTY_PRINT))) {
                $mensagem = "App cadastrado com sucesso!";
                $mensagem_sucesso = true;  // Marca o sucesso do cadastro
            } else {
                $mensagem = "Erro ao criar o arquivo JSON.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar App</title>
    <link rel="stylesheet" href="style.css">
    <script>
        // Mostrar barra de progresso
        function showProgressBar() {
            const progressBar = document.getElementById('progress-bar');
            progressBar.style.width = '0%';
            progressBar.style.transition = 'width 0.5s';

            const progressBarContainer = document.getElementById('progress-bar-container');
            progressBarContainer.style.display = 'block';  // Mostrar a barra de progresso

            let progress = 0;
            const interval = setInterval(function() {
                if (progress < 100) {
                    progress += 2;
                    progressBar.style.width = progress + '%';
                } else {
                    clearInterval(interval);
                }
            }, 100);
        }

        // Esconder a barra de progresso quando o sucesso for mostrado
        function hideProgressBar() {
            const progressBarContainer = document.getElementById('progress-bar-container');
            progressBarContainer.style.display = 'none';  // Esconder a barra de progresso
        }

        // Redirecionar após sucesso
        function redirectToListApp() {
            setTimeout(function() {
                window.location.href = 'listapp.php';
            }, 2000);
        }
    </script>
</head>
<style>
    body {
        font-family: 'Arial', sans-serif;
        background-color: #1e1e1e;
        color: #fff;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
    }

    .container {
        background-color: rgba(0, 0, 0, 0.7);
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0px 10px 30px rgba(0, 0, 0, 0.5);
        width: 100%;
        max-width: 600px;
        text-align: center;
        border: 1px solid;
    }

    h1 {
        font-size: 24px;
        margin-bottom: 20px;
        color: #fff;
    }

    .input-group {
        margin-bottom: 20px;
        text-align: left;
    }

    .input-group label {
        display: block;
        font-size: 14px;
        margin-bottom: 5px;
    }

    .input-group input,
    .input-group textarea {
        width: 100%;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #444;
        background-color: #333;
        color: #fff;
        font-size: 16px;
        box-sizing: border-box;
        transition: border-color 0.3s;
    }

    .input-group input:focus,
    .input-group textarea:focus {
        border-color: #1abc9c;
        outline: none;
    }

    .input-group textarea {
        resize: vertical;
    }

    button {
        background-color: #1abc9c;
        color: #fff;
        border: none;
        padding: 15px 30px;
        font-size: 18px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s;
    }

    button:hover {
        background-color: #16a085;
    }

    .mensagem {
        margin: 10px 0;
        padding: 10px;
        background-color: #2ecc71;
        color: #fff;
        border-radius: 5px;
    }

    .mensagem.error {
        background-color: #e74c3c;
    }

    #progress-bar-container {
        width: 100%;
        height: 10px;
        background-color: #444;
        margin-top: 20px;
        display: none; /* Inicia oculto */
    }

    #progress-bar {
        height: 100%;
        background-color: #1abc9c;
        width: 0;
    }
</style>
<body>
    <div class="container">
        <h1 style="color: white";>Cadastrar Aplicativo</h1>
        <?php if ($mensagem): ?>
            <p class="mensagem<?php echo strpos($mensagem, 'Erro') !== false ? ' error' : ''; ?>" id="mensagem"><?php echo $mensagem; ?></p>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data" onsubmit="showProgressBar()">
            <div class="input-group">
                <label for="nome">Nome do App</label>
                <input type="text" id="nome" name="nome" required>
            </div>
            <div class="input-group">
                <label for="logo">Logo do App (Você pode enviar múltiplas logos)</label>
                <input type="file" id="logo" name="logo[]" accept="image/*" multiple>
            </div>
            <div class="input-group">
                <label for="arquivo">Arquivo do App</label>
                <input type="file" id="arquivo" name="arquivo" accept=".apk,.zip,.exe">
            </div>
            <div class="input-group">
                <label for="descricao">Descrição</label>
                <textarea id="descricao" name="descricao" rows="4"></textarea>
            </div>
            <button type="submit">Cadastrar</button>
        </form>

        <div id="progress-bar-container">
            <div id="progress-bar"></div>
        </div>
        <?php include './includes/footer.php';?>
    </div>

    <?php if ($mensagem_sucesso): ?>
        <script>hideProgressBar(); redirectToListApp();</script>
    <?php endif; ?>
</body>
</html>
